using System;
using System.Xml;

namespace gov.va.med.vbecs.DAL.VistALink.OpenLibrary
{
	/// <summary>
	/// This exception is thrown when source XML string for VistALink message
	/// deserialization methods is not well-formed. 
	/// </summary>
	public class MalformedVistALinkMessageXmlSourceException : VistALinkException
	{
		/// <summary>
		/// This constructor accepts XmlException that caused the subject exception.
		/// </summary>
		/// <param name="inner">Initial XmlException that caused subject exception.</param>
		public MalformedVistALinkMessageXmlSourceException( XmlException inner )
			: base( SR.Exceptions.MalformedVistALinkMessageXmlString(), inner ) {}
	}
}
